const express = require("express");
const router = express.Router();
const tableName = require("../../Utils/allTableNames");
const { GlobalInsert } = require("../../GlobalFunctions/GlobalCreate");
const RESPONSE = require("../../GlobalResponse/RESPONSE");

router.post("/createProductDetails", (req, res) => {
  if (!req.body.lineName || !req.body.productName) {
    return res.status(400).send(RESPONSE(false, "Please Fill All fields", {}));
  }
  let payload = {
    tableName: tableName.ProductDetails,
    databaseFields: {
      lineName: req.body.lineName,
      productName: req.body.productName,
    },
  };
  GlobalInsert(payload, res);
});

module.exports = router;
