const express = require("express");
const router = express.Router();
const tableName = require("../../Utils/allTableNames");
const { GlobalInsert } = require("../../GlobalFunctions/GlobalCreate");
const RESPONSE = require("../../GlobalResponse/RESPONSE");

router.post("/createCategories", (req, res) => {
  if (!req.body.category) {
    return res.status(400).send(RESPONSE(false, "Please Fill All fields", {}));
  }
  let payload = {
    tableName: tableName.Categories,
    databaseFields: {
      category: req.body.category,
    },
  };
  GlobalInsert(payload, res);
});

module.exports = router;
