const express = require("express");
const cors = require("cors");
const morgan = require("morgan");
const http = require("http");
const app = express();

const appRouter = require("./routes")

app.use(cors());
app.use(morgan("dev"));
app.use(express.urlencoded({ extended: false }));
app.use(express.json());
app.use(express.static("public"));


app.get("/", function (req, res, next) {
  res.send("Success");
});

app.use("/", appRouter)

// ADD CALL to execute your function(s)
// scheduledFunctions.initScheduledJobs();


const server = http.createServer(app);
const PORT = process.env.PORT || 5000;
server.listen(PORT, () => {
  console.log("Server is running on: localhost:", PORT);
});
